<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../auth/middleware.php';

$path = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];

// Categories CRUD
if (strpos($path, '/categories') !== false) {
    switch ($method) {
        case 'GET':
            $stmt = $pdo->query("SELECT * FROM categories ORDER BY name ASC");
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            authenticate($pdo); // Only admins
            $data = json_decode(file_get_contents("php://input"));
            if (!empty($data->name)) {
                try {
                    $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data->name)));
                    $stmt = $pdo->prepare("INSERT INTO categories (name, slug) VALUES (:name, :slug)");
                    $stmt->execute(['name' => $data->name, 'slug' => $slug]);
                    echo json_encode(["status" => "success", "id" => $pdo->lastInsertId()]);
                } catch (Exception $e) {
                    http_response_code(500);
                    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
                }
            } else {
                http_response_code(400);
                echo json_encode(["error" => "Name is required"]);
            }
            break;

        case 'PUT':
            authenticate($pdo);
            $data = json_decode(file_get_contents("php://input"));
            if (!empty($data->id) && !empty($data->name)) {
                $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data->name)));
                $stmt = $pdo->prepare("UPDATE categories SET name = :name, slug = :slug WHERE id = :id");
                $stmt->execute(['name' => $data->name, 'slug' => $slug, 'id' => $data->id]);
                echo json_encode(["status" => "success"]);
            }
            break;

        case 'DELETE':
            authenticate($pdo);
            $id = $_GET['id'] ?? null;
            if ($id) {
                $stmt = $pdo->prepare("DELETE FROM categories WHERE id = :id");
                $stmt->execute(['id' => $id]);
                echo json_encode(["status" => "success"]);
            }
            break;
    }
} else {
    // Debug logging
    // file_put_contents('debug_path.log', "Path mismatch: " . $path . "\n", FILE_APPEND);
}
?>
