<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../auth/middleware.php';

// Only allow authenticated users
authenticate($pdo);

try {
    // 1. Total Recipes
    $recipesCount = $pdo->query("SELECT COUNT(*) FROM recipes")->fetchColumn();

    // 2. Total Categories
    $categoriesCount = $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn();

    // 3. Views Today
    $today = date('Y-m-d');
    $viewsToday = $pdo->prepare("SELECT SUM(view_count) FROM views_stats WHERE view_date = :today");
    $viewsToday->execute(['today' => $today]);
    $totalViewsToday = $viewsToday->fetchColumn() ?: 0;

    // 4. Total Authors
    $authorsCount = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

    // 5. Recent Recipes
    $recentRecipesStmt = $pdo->query("
        SELECT r.id, r.title, r.slug, r.cover_image, r.created_at, c.name as category_name 
        FROM recipes r 
        LEFT JOIN categories c ON r.category_id = c.id 
        ORDER BY r.created_at DESC 
        LIMIT 5
    ");
    $recentRecipes = $recentRecipesStmt->fetchAll();

    echo json_encode([
        "status" => "success",
        "data" => [
            "totalRecipes" => (int)$recipesCount,
            "totalCategories" => (int)$categoriesCount,
            "viewsToday" => (int)$totalViewsToday,
            "totalAuthors" => (int)$authorsCount,
            "recentRecipes" => $recentRecipes
        ]
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>
