<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . '/../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"));
    
    if (!empty($data->recipe_id)) {
        $recipe_id = $data->recipe_id;
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        // Optional: specific logic to prevent spam (e.g., check if IP viewed recently)
        // For now, we simply log every hit
        
        // Check if IP viewed this recipe in the last 24 hours
        $checkStmt = $pdo->prepare("SELECT COUNT(*) FROM recipe_views WHERE recipe_id = :recipe_id AND ip_address = :ip_address AND viewed_at > (NOW() - INTERVAL 1 DAY)");
        $checkStmt->execute([
            ':recipe_id' => $recipe_id,
            ':ip_address' => $ip_address
        ]);
        $alreadyViewed = $checkStmt->fetchColumn();

        if ($alreadyViewed == 0) {
            try {
                $stmt = $pdo->prepare("INSERT INTO recipe_views (recipe_id, ip_address, user_agent) VALUES (:recipe_id, :ip_address, :user_agent)");
                $stmt->execute([
                    ':recipe_id' => $recipe_id,
                    ':ip_address' => $ip_address,
                    ':user_agent' => $user_agent
                ]);
                
                echo json_encode(["status" => "success", "message" => "View counted"]);
            } catch (PDOException $e) {
                http_response_code(500);
                echo json_encode(["error" => "Database error: " . $e->getMessage()]);
            }
        } else {
            echo json_encode(["status" => "ignored", "message" => "View already counted today"]);
        }

    } else {
        http_response_code(400);
        echo json_encode(["error" => "Recipe ID is required"]);
    }
} else {
    http_response_code(405);
    echo json_encode(["error" => "Method not allowed"]);
}
?>
