<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../auth/middleware.php';

$method = $_SERVER['REQUEST_METHOD'];
$path = $_SERVER['REQUEST_URI'];

// Questions and Comments and Likes
if (strpos($path, '/interactions') !== false) {
    switch ($method) {
        case 'GET':
            $type = $_GET['type'] ?? 'comments';
            $recipe_id = $_GET['recipe_id'] ?? null;
            
            if ($type === 'comments') {
                authenticate($pdo); // Require auth for viewing all/managing
                
                // If ID is provided, fetch specific comment check
                $id = $_GET['id'] ?? null;
                
                if ($id) {
                     $stmt = $pdo->prepare("SELECT * FROM comments WHERE id = :id");
                     $stmt->execute(['id' => $id]);
                     echo json_encode($stmt->fetch());
                } else {
                     // Fetch all comments (for admin dashboard), or filter by recipe if needed
                     $query = "SELECT c.*, r.title as recipe_title FROM comments c LEFT JOIN recipes r ON c.recipe_id = r.id ORDER BY c.created_at DESC";
                     if ($recipe_id) {
                         $query = "SELECT * FROM comments WHERE recipe_id = :recipe_id ORDER BY created_at DESC";
                     }
                     
                     $stmt = $pdo->prepare($query);
                     if ($recipe_id) $stmt->execute(['recipe_id' => $recipe_id]);
                     else $stmt->execute();
                     echo json_encode($stmt->fetchAll());
                }
            } elseif ($type === 'questions') {
                $query = "SELECT q.*, r.title as recipe_title FROM questions q LEFT JOIN recipes r ON q.recipe_id = r.id ORDER BY q.created_at DESC";
                if ($recipe_id) $query = "SELECT * FROM questions WHERE recipe_id = :recipe_id ORDER BY created_at DESC";
                
                $stmt = $pdo->prepare($query);
                if ($recipe_id) $stmt->execute(['recipe_id' => $recipe_id]);
                else $stmt->execute();
                echo json_encode($stmt->fetchAll());
            } elseif ($type === 'likes') {
                $recipe_id = $_GET['recipe_id'] ?? null;
                if ($recipe_id) {
                    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM likes WHERE recipe_id = :recipe_id");
                    $stmt->execute(['recipe_id' => $recipe_id]);
                    echo json_encode($stmt->fetch());
                }
            }
            break;

        case 'POST':
            $data = json_decode(file_get_contents("php://input"));
            $type = $data->type ?? '';

            if ($type === 'comment') {
                $stmt = $pdo->prepare("INSERT INTO comments (recipe_id, user_name, comment_text, parent_id) VALUES (:recipe_id, :user_name, :comment_text, :parent_id)");
                $stmt->execute([
                    'recipe_id' => $data->recipe_id,
                    'user_name' => $data->user_name,
                    'comment_text' => $data->comment_text,
                    'parent_id' => $data->parent_id ?? null
                ]);
                echo json_encode(["status" => "success"]);
            } elseif ($type === 'question') {
                $stmt = $pdo->prepare("INSERT INTO questions (recipe_id, user_name, user_email, question_text) VALUES (:recipe_id, :user_name, :user_email, :question_text)");
                $stmt->execute([
                    'recipe_id' => $data->recipe_id,
                    'user_name' => $data->user_name,
                    'user_email' => $data->user_email,
                    'question_text' => $data->question_text
                ]);
                echo json_encode(["status" => "success"]);
            } elseif ($type === 'like') {
                $recipe_id = $data->recipe_id;
                $user_ip = $_SERVER['REMOTE_ADDR'];
                
                // Check if already liked
                $stmt = $pdo->prepare("SELECT id FROM likes WHERE recipe_id = :recipe_id AND user_ip = :user_ip");
                $stmt->execute(['recipe_id' => $recipe_id, 'user_ip' => $user_ip]);
                
                if (!$stmt->fetch()) {
                    $stmt = $pdo->prepare("INSERT INTO likes (recipe_id, user_ip) VALUES (:recipe_id, :user_ip)");
                    $stmt->execute(['recipe_id' => $recipe_id, 'user_ip' => $user_ip]);
                    echo json_encode(["status" => "success", "action" => "liked"]);
                } else {
                    $stmt = $pdo->prepare("DELETE FROM likes WHERE recipe_id = :recipe_id AND user_ip = :user_ip");
                    $stmt->execute(['recipe_id' => $recipe_id, 'user_ip' => $user_ip]);
                    echo json_encode(["status" => "success", "action" => "unliked"]);
                }
            }
            break;
            
        case 'PUT':
            // Answer questions, approve comments (Admin only)
            authenticate($pdo);
            $data = json_decode(file_get_contents("php://input"));
            
            if ($data->type === 'answer') {
                $stmt = $pdo->prepare("UPDATE questions SET answer_text = :answer, is_answered = 1 WHERE id = :id");
                $stmt->execute(['answer' => $data->answer, 'id' => $data->id]);
                echo json_encode(["status" => "success"]);
            } elseif ($data->type === 'approve_comment') {
                $stmt = $pdo->prepare("UPDATE comments SET is_approved = 1 WHERE id = :id");
                $stmt->execute(['id' => $data->id]);
                echo json_encode(["status" => "success"]);
            }
            break;

        case 'DELETE':
            authenticate($pdo);
            $type = $_GET['type'] ?? '';
            $id = $_GET['id'] ?? null;
            
            if ($type === 'comment' && $id) {
                $stmt = $pdo->prepare("DELETE FROM comments WHERE id = :id");
                $stmt->execute(['id' => $id]);
                echo json_encode(["status" => "success"]);
            } elseif ($type === 'question' && $id) {
                $stmt = $pdo->prepare("DELETE FROM questions WHERE id = :id");
                $stmt->execute(['id' => $id]);
                echo json_encode(["status" => "success"]);
            }
            break;
    }
}
?>
