<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../auth/middleware.php';

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        $slug = $_GET['slug'] ?? null;
        if ($slug) {
            // Fetch single recipe with view count
            $stmt = $pdo->prepare("
                SELECT r.*, c.name as category_name,
                (SELECT COUNT(*) FROM recipe_views rv WHERE rv.recipe_id = r.id) as view_count
                FROM recipes r 
                LEFT JOIN categories c ON r.category_id = c.id 
                WHERE r.slug = :slug
            ");
            $stmt->execute(['slug' => $slug]);
            $recipe = $stmt->fetch();
            
            if ($recipe) {
                echo json_encode($recipe);
            } else {
                http_response_code(404);
                echo json_encode(["error" => "Recipe not found"]);
            }
        } else {
            // Fetch all recipes with view count, optionally filtered by search or category
            $search = $_GET['search'] ?? null;
            $category = $_GET['category'] ?? null;
            $params = [];
            
            $sql = "
                SELECT r.*, c.name as category_name, c.slug as category_slug,
                (SELECT COUNT(*) FROM recipe_views rv WHERE rv.recipe_id = r.id) as view_count
                FROM recipes r 
                LEFT JOIN categories c ON r.category_id = c.id 
                WHERE 1=1
            ";

            if ($search) {
                $sql .= " AND (r.title LIKE :search1 OR r.short_description LIKE :search2 OR c.name LIKE :search3) ";
                $params['search1'] = "%$search%";
                $params['search2'] = "%$search%";
                $params['search3'] = "%$search%";
            }

            if ($category) {
                $sql .= " AND c.slug = :category ";
                $params['category'] = $category;
            }

            $sql .= " ORDER BY r.created_at DESC";

            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
        }
        break;

    case 'POST':
        authenticate($pdo);
        $data = json_decode(file_get_contents("php://input"));
        
        if (!empty($data->title)) {
            $slug = !empty($data->slug) ? $data->slug : strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data->title)));
            
            // Image Upload Logic
            $cover_image_path = $data->cover_image ?? null;
            
            if ($cover_image_path && preg_match('/^data:image\/(\w+);base64,/', $cover_image_path, $type)) {
                $data64 = substr($cover_image_path, strpos($cover_image_path, ',') + 1);
                $ext = strtolower($type[1]); // jpg, png, gif, webp
                if (in_array($ext, [ 'jpg', 'jpeg', 'gif', 'png', 'webp' ])) {
                    $decoded = base64_decode($data64);
                    $dir = 'C:/xampp/htdocs/helafood-api/uploads/';
                    if (!file_exists($dir)) {
                        mkdir($dir, 0777, true);
                    }
                    $filename = uniqid() . '.' . $ext;
                    if(file_put_contents($dir . $filename, $decoded)){
                        $cover_image_path = 'uploads/' . $filename;
                    }
                }
            }

            $current_user_id = $user['id'] ?? 1; // Fallback to 1 if auth fails/test mode
            $is_published = isset($data->is_published) ? (int)$data->is_published : 0;

            if (!empty($data->id)) {
                // UPDATE
                $query = "UPDATE recipes SET 
                            title = :title, 
                            slug = :slug, 
                            short_description = :short_description, 
                            description = :description, 
                            ingredients = :ingredients, 
                            instructions = :instructions, 
                            category_id = :category_id, 
                            cover_image = :cover_image, 
                            tags = :tags, 
                            meta_title = :meta_title, 
                            meta_description = :meta_description, 
                            is_published = :is_published 
                          WHERE id = :id";
                
                $stmt = $pdo->prepare($query);
                $stmt->execute([
                    ':title' => $data->title,
                    ':slug' => $slug,
                    ':short_description' => $data->short_description ?? '',
                    ':description' => $data->description ?? '',
                    ':ingredients' => $data->ingredients ?? '',
                    ':instructions' => $data->instructions ?? '',
                    ':category_id' => !empty($data->category_id) ? $data->category_id : null,
                    ':cover_image' => $cover_image_path,
                    ':tags' => $data->tags ?? '',
                    ':meta_title' => $data->meta_title ?? '',
                    ':meta_description' => $data->meta_description ?? '',
                    ':is_published' => $is_published,
                    ':id' => $data->id
                ]);
                echo json_encode(["status" => "success", "message" => "Recipe updated successfully."]);

            } else {
                // INSERT
                $query = "INSERT INTO recipes (title, slug, short_description, description, ingredients, instructions, category_id, cover_image, tags, meta_title, meta_description, author_id, is_published) 
                          VALUES (:title, :slug, :short_description, :description, :ingredients, :instructions, :category_id, :cover_image, :tags, :meta_title, :meta_description, :author_id, :is_published)";
                
                $stmt = $pdo->prepare($query);
                $stmt->execute([
                    ':title' => $data->title,
                    ':slug' => $slug,
                    ':short_description' => $data->short_description ?? '',
                    ':description' => $data->description ?? '',
                    ':ingredients' => $data->ingredients ?? '',
                    ':instructions' => $data->instructions ?? '',
                    ':category_id' => !empty($data->category_id) ? $data->category_id : null,
                    ':cover_image' => $cover_image_path,
                    ':tags' => $data->tags ?? '',
                    ':meta_title' => $data->meta_title ?? '',
                    ':meta_description' => $data->meta_description ?? '',
                    ':author_id' => $current_user_id,
                    ':is_published' => $is_published
                ]);
                echo json_encode(["status" => "success", "message" => "Recipe published successfully.", "id" => $pdo->lastInsertId()]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["error" => "Title is required."]);
        }
        break;

    case 'DELETE':
        authenticate($pdo);
        $id = $_GET['id'] ?? null;
        if ($id) {
            $stmt = $pdo->prepare("DELETE FROM recipes WHERE id = :id");
            $stmt->execute(['id' => $id]);
            echo json_encode(["status" => "success", "message" => "Recipe deleted."]);
        }
        break;
}
?>
