<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Error handling to prevent HTML output
error_reporting(E_ALL);
ini_set('display_errors', 0);

function sendError($message, $code = 500) {
    http_response_code($code);
    echo json_encode(["error" => $message]);
    exit();
}

try {
    require_once __DIR__ . '/../config/db.php';

    $query = $_GET['q'] ?? $_GET['search'] ?? '';

    if (empty($query)) {
        echo json_encode([]);
        exit();
    }

    // Search query - targeting title, description, and category name
    // Limit to 10 results for performance
    $sql = "
        SELECT r.id, r.title, r.slug, r.cover_image, r.category_id, c.name as category_name
        FROM recipes r
        LEFT JOIN categories c ON r.category_id = c.id
        WHERE r.title LIKE :search1 
           OR r.short_description LIKE :search2 
           OR c.name LIKE :search3
        LIMIT 10
    ";

    $stmt = $pdo->prepare($sql);
    $searchTerm = "%$query%";
    $stmt->execute([
        'search1' => $searchTerm,
        'search2' => $searchTerm,
        'search3' => $searchTerm
    ]);
    
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($results);

} catch (PDOException $e) {
    // Log actual error to file if needed, but return generic JSON to client
    error_log("Database Error in search.php: " . $e->getMessage());
    sendError("Database error occurred.");
} catch (Exception $e) {
    error_log("General Error in search.php: " . $e->getMessage());
    sendError("An unexpected error occurred.");
}
?>
