<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../auth/middleware.php';

$method = $_SERVER['REQUEST_METHOD'];
$user_data = authenticate($pdo); // Get current logged in user from token
$user_id = $user_data->id;

if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"));
    
    // Change Password
    if (!empty($data->new_password) && !empty($data->current_password)) {
        // Verify current password first
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = :id");
        $stmt->execute(['id' => $user_id]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($data->current_password, $user['password'])) {
            $new_password_hash = password_hash($data->new_password, PASSWORD_DEFAULT);
            $update = $pdo->prepare("UPDATE users SET password = :password WHERE id = :id");
            $update->execute(['password' => $new_password_hash, 'id' => $user_id]);
            echo json_encode(["status" => "success", "message" => "Password updated successfully"]);
        } else {
            http_response_code(400);
            echo json_encode(["error" => "Incorrect current password"]);
        }
    } 
    // Update Profile Info
    elseif (!empty($data->username)) {
         // Check if username taken
         $check = $pdo->prepare("SELECT id FROM users WHERE username = :username AND id != :id");
         $check->execute(['username' => $data->username, 'id' => $user_id]);
         if ($check->fetch()) {
             http_response_code(400);
             echo json_encode(["error" => "Username already taken"]);
             exit;
         }
         
         $stmt = $pdo->prepare("UPDATE users SET username = :username WHERE id = :id");
         $stmt->execute(['username' => $data->username, 'id' => $user_id]);
         
         // Return new user object for frontend to update local storage
         echo json_encode([
             "status" => "success", 
             "message" => "Profile updated",
             "user" => ["id" => $user_id, "username" => $data->username]
         ]);
    } else {
        http_response_code(400);
        echo json_encode(["error" => "No valid data provided"]);
    }
}
?>
