<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/db.php';

use Firebase\JWT\JWT;

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->username) && !empty($data->password)) {
    $username = $data->username;
    $password = $data->password;

    $query = "SELECT id, username, password FROM users WHERE username = :username LIMIT 0,1";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $secret_key = $_ENV['JWT_SECRET'];
        $issuer_claim = "helafood_api"; 
        $audience_claim = "helafood_dashboard";
        $issuedat_claim = time(); 
        $notbefore_claim = $issuedat_claim; 
        $expire_claim = $issuedat_claim + (int)$_ENV['JWT_EXPIRATION']; 
        
        $token = array(
            "iss" => $issuer_claim,
            "aud" => $audience_claim,
            "iat" => $issuedat_claim,
            "nbf" => $notbefore_claim,
            "exp" => $expire_claim,
            "data" => array(
                "id" => $user['id'],
                "username" => $user['username']
            )
        );

        $jwt = JWT::encode($token, $secret_key, 'HS256');
        
        if (ob_get_length()) ob_end_clean();
        http_response_code(200);
        echo json_encode(array(
            "message" => "Successful login.",
            "jwt" => $jwt,
            "user" => array(
                "id" => $user['id'],
                "username" => $user['username']
            ),
            "expireAt" => $expire_claim
        ));
    } else {
        http_response_code(401);
        echo json_encode(array("message" => "Login failed. Invalid username or password."));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
