<?php
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

/**
 * Validates the JWT token from Authorization header
 * @param PDO $pdo Optional database connection
 * @return object The decoded token data
 */
function authenticate($pdo = null) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    
    // Some servers might strip the header, try apache_request_headers as fallback
    if (empty($authHeader) && function_exists('apache_request_headers')) {
        $headers = apache_request_headers();
        $authHeader = $headers['Authorization'] ?? '';
    }

    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $jwt = $matches[1];
        try {
            $decoded = JWT::decode($jwt, new Key($_ENV['JWT_SECRET'], 'HS256'));
            return $decoded->data;
        } catch (Exception $e) {
            http_response_code(401);
            echo json_encode([
                "error" => "Unauthorized",
                "message" => "Access denied. " . $e->getMessage()
            ]);
            exit;
        }
    } else {
        http_response_code(401);
        echo json_encode([
            "error" => "Unauthorized",
            "message" => "Access denied. Token missing or invalid."
        ]);
        exit;
    }
}
?>
