<?php
require_once 'config/db.php';

try {
    // Drop old table to ensure new schema is applied
    $pdo->exec("DROP TABLE IF EXISTS comments");
    
    // Recreate table with new schema
    $sql = "CREATE TABLE comments (
        id INT AUTO_INCREMENT PRIMARY KEY,
        recipe_id INT,
        user_name VARCHAR(100),
        comment_text TEXT NOT NULL,
        parent_id INT DEFAULT NULL,
        is_approved BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (recipe_id) REFERENCES recipes(id) ON DELETE CASCADE,
        FOREIGN KEY (parent_id) REFERENCES comments(id) ON DELETE CASCADE
    ) ENGINE=InnoDB;";
    
    $pdo->exec($sql);
    
    echo json_encode(["success" => true, "message" => "Comments table reset successfully with new schema."]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "Reset failed: " . $e->getMessage()]);
}
?>
